"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
const error_1 = require("@b/utils/error");
const utils_1 = require("./utils");
exports.metadata = {
    summary: "Retrieves the profile of the current user",
    description: "Fetches the profile of the currently authenticated user",
    operationId: "getProfile",
    tags: ["Auth"],
    requiresAuth: true,
    responses: {
        200: {
            description: "User profile retrieved successfully",
            content: {
                "application/json": {
                    schema: {
                        type: "object",
                        properties: {
                            id: { type: "string", description: "ID of the user" },
                            email: { type: "string", description: "Email of the user" },
                            firstName: {
                                type: "string",
                                description: "First name of the user",
                            },
                            lastName: {
                                type: "string",
                                description: "Last name of the user",
                            },
                            role: { type: "string", description: "Role of the user" },
                            createdAt: {
                                type: "string",
                                format: "date-time",
                                description: "Date and time when the user was created",
                            },
                            updatedAt: {
                                type: "string",
                                format: "date-time",
                                description: "Date and time when the user was last updated",
                            },
                            featureAccess: {
                                type: "array",
                                description: "List of feature ids enabled for this user's KYC level",
                                items: { type: "string" },
                            },
                        },
                        required: [
                            "id",
                            "email",
                            "firstName",
                            "lastName",
                            "role",
                            "createdAt",
                            "updatedAt",
                            "featureAccess",
                        ],
                    },
                },
            },
        },
        401: query_1.unauthorizedResponse,
        404: (0, query_1.notFoundMetadataResponse)("User"),
        500: query_1.serverErrorResponse,
    },
};
exports.default = async (data) => {
    const { user } = data;
    if (!(user === null || user === void 0 ? void 0 : user.id)) {
        throw (0, error_1.createError)({
            statusCode: 401,
            message: "Authentication required, Please log in.",
        });
    }
    return await (0, utils_1.getUserById)(user.id);
};
